/*
 * SPDX-License-Identifier: BSD-3-Clause
 * SPDX-FileCopyrightText: Copyright TF-RMM Contributors.
 */

#ifndef PSCI_H
#define PSCI_H

#include <smc.h>
#include <status.h>
#include <stdbool.h>

#define SMC32_PSCI_FID(_offset)		SMC32_STD_FID(PSCI, _offset)
#define SMC64_PSCI_FID(_offset)		SMC64_STD_FID(PSCI, _offset)

#define IS_SMC32_PSCI_FID(_fid)		IS_SMC32_STD_FAST_IN_RANGE(PSCI, _fid)
#define IS_SMC64_PSCI_FID(_fid)		IS_SMC64_STD_FAST_IN_RANGE(PSCI, _fid)

#define SMC32_PSCI_FID_MIN		SMC32_PSCI_FID(SMC32_PSCI_FNUM_MIN)
#define SMC32_PSCI_FID_MAX		SMC32_PSCI_FID(SMC32_PSCI_FNUM_MAX)

#define SMC64_PSCI_FID_MIN		SMC64_PSCI_FID(SMC64_PSCI_FNUM_MIN)
#define SMC64_PSCI_FID_MAX		SMC64_PSCI_FID(SMC64_PSCI_FNUM_MAX)

#define SMC32_PSCI_VERSION		SMC32_PSCI_FID(0x0U)

#define SMC32_PSCI_CPU_SUSPEND		SMC32_PSCI_FID(0x1U)
#define SMC64_PSCI_CPU_SUSPEND		SMC64_PSCI_FID(0x1U)

#define SMC32_PSCI_CPU_OFF		SMC32_PSCI_FID(0x2U)

#define SMC32_PSCI_CPU_ON		SMC32_PSCI_FID(0x3U)
#define SMC64_PSCI_CPU_ON		SMC64_PSCI_FID(0x3U)

#define SMC32_PSCI_AFFINITY_INFO	SMC32_PSCI_FID(0x4U)
#define SMC64_PSCI_AFFINITY_INFO	SMC64_PSCI_FID(0x4U)

#define SMC32_PSCI_MIGRATE		SMC32_PSCI_FID(0x5U)
#define SMC64_PSCI_MIGRATE		SMC64_PSCI_FID(0x5U)

#define SMC32_PSCI_MIGRATE_INFO_TYPE	SMC32_PSCI_FID(0x6U)

#define SMC32_PSCI_MIGRATE_INFO_UP_CPU	SMC32_PSCI_FID(0x7U)
#define SMC64_PSCI_MIGRATE_INFO_UP_CPU	SMC64_PSCI_FID(0x7U)

#define SMC32_PSCI_SYSTEM_OFF		SMC32_PSCI_FID(0x8U)

#define SMC32_PSCI_SYSTEM_RESET		SMC32_PSCI_FID(0x9U)

#define SMC32_PSCI_FEATURES		SMC32_PSCI_FID(0xAU)

#define SMC32_PSCI_CPU_FREEZE		SMC32_PSCI_FID(0xBU)

#define SMC32_PSCI_CPU_DEFAULT_SUSPEND	SMC32_PSCI_FID(0xCU)
#define SMC64_PSCI_CPU_DEFAULT_SUSPEND	SMC64_PSCI_FID(0xCU)

#define SMC32_PSCI_NODE_HW_STATE	SMC32_PSCI_FID(0xDU)
#define SMC64_PSCI_NODE_HW_STATE	SMC64_PSCI_FID(0xDU)

#define SMC32_PSCI_SYSTEM_SUSPEND	SMC32_PSCI_FID(0xEU)
#define SMC64_PSCI_SYSTEM_SUSPEND	SMC64_PSCI_FID(0xEU)

#define SMC32_PSCI_SET_SUSPEND_MODE	SMC32_PSCI_FID(0xFU)

#define SMC32_PSCI_STAT_RESIDENCY	SMC32_PSCI_FID(0x10U)
#define SMC64_PSCI_STAT_RESIDENCY	SMC64_PSCI_FID(0x10U)

#define SMC32_PSCI_STAT_COUNT		SMC32_PSCI_FID(0x11U)
#define SMC64_PSCI_STAT_COUNT		SMC64_PSCI_FID(0x11U)

#define SMC32_PSCI_SYSTEM_RESET2	SMC32_PSCI_FID(0x12U)
#define SMC64_PSCI_SYSTEM_RESET2	SMC64_PSCI_FID(0x12U)

#define SMC32_PSCI_MEM_PROTECT		SMC32_PSCI_FID(0x13U)

#define SMC32_PSCI_MEM_PROTECT_CHECK_RANGE	SMC32_PSCI_FID(0x14U)
#define SMC64_PSCI_MEM_PROTECT_CHECK_RANGE	SMC64_PSCI_FID(0x14U)

#define PSCI_RETURN_SUCCESS		UL(0)
#define PSCI_RETURN_NOT_SUPPORTED	UL(-1)
#define PSCI_RETURN_INVALID_PARAMS	UL(-2)
#define PSCI_RETURN_DENIED		UL(-3)
#define PSCI_RETURN_ALREADY_ON		UL(-4)
#define PSCI_RETURN_ON_PENDING		UL(-5)
#define PSCI_RETURN_INTERNAL_FAILURE	UL(-6)
#define PSCI_RETURN_NOT_PRESENT		UL(-7)
#define PSCI_RETURN_DISABLED		UL(-8)
#define PSCI_RETURN_INVALID_ADDRESS	UL(-9)

#define PSCI_AFFINITY_INFO_ON		UL(0)
#define PSCI_AFFINITY_INFO_OFF		UL(1)
#define PSCI_AFFINITY_INFO_ON_PENDING	UL(2)

#define PSCI_NODE_HW_ON			UL(0)
#define PSCI_NODE_HW_OFF		UL(1)
#define PSCI_NODE_HW_STANDBY		UL(2)

struct rec;

struct psci_result {
	struct {
		bool forward_psci_call;
		unsigned long x1;
		unsigned long x2;
		unsigned long x3;
	} hvc_forward;
	struct smc_result smc_res;
};

struct psci_result psci_rsi(struct rec *rec,
			    unsigned int function_id,
			    unsigned long arg0,
			    unsigned long arg1,
			    unsigned long arg2);

unsigned long psci_complete_request(struct rec *calling_rec,
				    struct rec *target_rec);

#endif /* PSCI_H */
